package GUI.doABC;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;

import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;

import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

import FlashReader.AbcFile;
import FlashReader.DoABC;
import FlashReader.SWF;
import Main.Main;

import doABC.*;
import doABC.Cpool.MultinameInfo;
import doABC.Cpool.NamespaceInfo;
import doABC.Cpool.StringInfo;
import doABC.Trait.Trait_Slot_Const;
import doABC.Trait.Trait_class;
import doABC.Trait.Trait_function;
import doABC.Trait.Trait_method_getter_setter;

public class GUI_traits_info extends JInternalFrame {
	
	private ButtonGroup buttonGroup = new ButtonGroup();
	private JRadioButton kindRadioButton;
	private JComboBox comboBox_kind;
	private JComboBox comboBox_metadata_2;
	private JFormattedTextField formattedTextField_disp_id;
	private JLabel disp_idLabel;
	private JFormattedTextField formattedTextField_vkind;
	private JComboBox comboBox_vindex;
	private JLabel metadata_countLabel;
	private JRadioButton vkindRadioButton;
	private JComboBox comboBox_function;
	private JFormattedTextField formattedTextField_function;
	private JRadioButton functionRadioButton;
	private JComboBox comboBox_method;
	private JFormattedTextField formattedTextField_method;
	private JRadioButton methodRadioButton;
	private JComboBox comboBox_classi;
	private JFormattedTextField formattedTextField_classi;
	private JRadioButton classiRadioButton;
	private JComboBox comboBox_vkind;
	private JFormattedTextField formattedTextField_vindex;
	private JRadioButton vindexRadioButton;
	private JComboBox comboBox_type_name;
	private JFormattedTextField formattedTextField_type_name;
	private JRadioButton type_nameRadioButton;
	private JFormattedTextField formattedTextField_slot_id;
	private JLabel slot_idLabel;
	private JCheckBox attr_metadataCheckBox;
	private JCheckBox attr_overrideCheckBox;
	private JCheckBox attr_finalCheckBox;
	private SpringLayout springLayout_2;
	private JLabel modyfikacjeLabel;
	private JPanel panel_1;
	private SpringLayout springLayout_1;
	private JLabel traits_infoLabel;
	private JButton dodajButton_1;
	private JButton usunButton_1;
	private JPanel panel;
	private JButton zamienButton;
	private JButton usunButton;
	private JButton dodajButton;
	private CpoolInfo cpool;
	private TraitInfo trait;
	
	private JComboBox comboBox_metadata;
	private JTextField textField_metadata_count;
	private JTextField textField_kind;
	private JTextField textField_name;
	private JComboBox comboBox_name;
	private JComboBox comboBox;
	private JRadioButton metadataRadioButton;
	private JRadioButton nameRadioButton;
	private SpringLayout springLayout;
	private SWF swf;
	private ArrayList<TraitInfo> ENtraits_info;
	
	public GUI_traits_info(final CpoolInfo cpool,  SWF swf, ArrayList<TraitInfo> ENtraits_info ) {
		super("traits_info",
		          true, //resizable
		          true, //closable
		          true, //maximizable
		          true);//iconifiable
		this.swf = swf;
		this.cpool = cpool;
		this.ENtraits_info=ENtraits_info;
		springLayout = new SpringLayout();
		getContentPane().setLayout(springLayout);
		setBounds(100, 100, 789, 640);
		nameRadioButton = new JRadioButton();
		nameRadioButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				dodajButton.setEnabled(false);
				usunButton.setEnabled(false);
				zamienButton.setEnabled(true);
			}
		});
		buttonGroup.add(nameRadioButton);
		nameRadioButton.setText("name");
		getContentPane().add(nameRadioButton);
		springLayout.putConstraint(SpringLayout.SOUTH, nameRadioButton, 74, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, nameRadioButton, 43, SpringLayout.NORTH, getContentPane());
		metadataRadioButton = new JRadioButton();
		metadataRadioButton.setEnabled(false);
		buttonGroup.add(metadataRadioButton);
		metadataRadioButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				dodajButton.setEnabled(true);
				usunButton.setEnabled(true);
				zamienButton.setEnabled(true);
			}
		});
		metadataRadioButton.setText("metadata");
		getContentPane().add(metadataRadioButton);
		comboBox_name = new JComboBox();
		
		getContentPane().add(comboBox_name);
		springLayout.putConstraint(SpringLayout.EAST, comboBox_name, 760, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.WEST, comboBox_name, 460, SpringLayout.WEST, getContentPane());
		textField_name = new JTextField();
		textField_name.setEditable(false);
		getContentPane().add(textField_name);
		springLayout.putConstraint(SpringLayout.EAST, textField_name, 425, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.WEST, textField_name, 125, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, textField_name, 50, SpringLayout.NORTH, getContentPane());
		textField_kind = new JTextField();
		getContentPane().add(textField_kind);
		springLayout.putConstraint(SpringLayout.EAST, textField_kind, 425, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.WEST, textField_kind, 125, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.SOUTH, textField_kind, 25, SpringLayout.SOUTH, nameRadioButton);
		springLayout.putConstraint(SpringLayout.NORTH, textField_kind, 5, SpringLayout.SOUTH, nameRadioButton);
		textField_metadata_count = new JTextField();
		textField_metadata_count.setEditable(false);
		getContentPane().add(textField_metadata_count);
		springLayout.putConstraint(SpringLayout.SOUTH, textField_metadata_count, 513, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, textField_metadata_count, 493, SpringLayout.NORTH, getContentPane());
		comboBox_metadata = new JComboBox();
		getContentPane().add(comboBox_metadata);
		springLayout.putConstraint(SpringLayout.SOUTH, comboBox_metadata, 558, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, comboBox_metadata, 533, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.EAST, comboBox_metadata, 305, SpringLayout.EAST, metadataRadioButton);
		springLayout.putConstraint(SpringLayout.WEST, comboBox_metadata, 5, SpringLayout.EAST, metadataRadioButton);
		panel = new JPanel();
		panel.setBackground(Color.ORANGE);
		springLayout_1 = new SpringLayout();
		panel.setLayout(springLayout_1);
		getContentPane().add(panel);
		springLayout.putConstraint(SpringLayout.EAST, nameRadioButton, 85, SpringLayout.WEST, panel);
		springLayout.putConstraint(SpringLayout.WEST, nameRadioButton, 5, SpringLayout.WEST, panel);
		springLayout.putConstraint(SpringLayout.SOUTH, panel, 35, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, panel, 0, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.EAST, panel, 774, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.WEST, panel, 5, SpringLayout.WEST, getContentPane());
		traits_infoLabel = new JLabel();
		traits_infoLabel.setText("traits_info");
		panel.add(traits_infoLabel);
		springLayout_1.putConstraint(SpringLayout.SOUTH, traits_infoLabel, 26, SpringLayout.NORTH, panel);
		springLayout_1.putConstraint(SpringLayout.NORTH, traits_infoLabel, 10, SpringLayout.NORTH, panel);
		springLayout_1.putConstraint(SpringLayout.EAST, traits_infoLabel, 71, SpringLayout.WEST, panel);
		springLayout_1.putConstraint(SpringLayout.WEST, traits_infoLabel, 5, SpringLayout.WEST, panel);
		dodajButton_1 = new JButton();
		dodajButton_1.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				new TraitInfo(((DoABC)Main.choosedTag).getAbcData(),trait.getName(),trait.getKind(),trait.getData(),trait.getMetadata_count(),trait.getMetadata());
				init();
				
			}
		});
		dodajButton_1.setText("Dodaj");
		dodajButton_1.setText(SWF.msgs.getString("add"));
		panel.add(dodajButton_1);
		springLayout_1.putConstraint(SpringLayout.EAST, dodajButton_1, 166, SpringLayout.WEST, panel);
		springLayout_1.putConstraint(SpringLayout.WEST, dodajButton_1, 76, SpringLayout.WEST, panel);
		springLayout_1.putConstraint(SpringLayout.SOUTH, dodajButton_1, 31, SpringLayout.NORTH, panel);
		springLayout_1.putConstraint(SpringLayout.NORTH, dodajButton_1, 5, SpringLayout.NORTH, panel);
		usunButton_1 = new JButton();
		usunButton_1.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				//TraitInfo.removeTraitInfo(trait.getId());
				init();
				/*if (gui_instance!=null)
					gui_instance.init();
				if (gui_method!=null)
					gui_method.init();*/
			}
		});
		usunButton_1.setText("Usu");
		usunButton_1.setText(SWF.msgs.getString("remove"));
		panel.add(usunButton_1);
		springLayout_1.putConstraint(SpringLayout.EAST, usunButton_1, 95, SpringLayout.EAST, dodajButton_1);
		springLayout_1.putConstraint(SpringLayout.WEST, usunButton_1, 5, SpringLayout.EAST, dodajButton_1);
		springLayout_1.putConstraint(SpringLayout.SOUTH, usunButton_1, 31, SpringLayout.NORTH, panel);
		springLayout_1.putConstraint(SpringLayout.NORTH, usunButton_1, 5, SpringLayout.NORTH, panel);
		comboBox = new JComboBox();
		panel.add(comboBox);
		springLayout_1.putConstraint(SpringLayout.SOUTH, comboBox, 31, SpringLayout.NORTH, panel);
		springLayout_1.putConstraint(SpringLayout.NORTH, comboBox, 6, SpringLayout.NORTH, panel);
		springLayout_1.putConstraint(SpringLayout.EAST, comboBox, 764, SpringLayout.WEST, panel);
		springLayout_1.putConstraint(SpringLayout.WEST, comboBox, 315, SpringLayout.WEST, panel);
		comboBox.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				trait = (TraitInfo)comboBox.getSelectedItem();
				set();
			}
		});
		panel_1 = new JPanel();
		panel_1.setBackground(Color.GRAY);
		springLayout_2 = new SpringLayout();
		panel_1.setLayout(springLayout_2);
		getContentPane().add(panel_1);
		springLayout.putConstraint(SpringLayout.EAST, panel_1, 587, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.WEST, panel_1, 192, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.SOUTH, metadataRadioButton, 557, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, metadataRadioButton, -29, SpringLayout.NORTH, panel_1);
		springLayout.putConstraint(SpringLayout.SOUTH, panel_1, 602, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, panel_1, 563, SpringLayout.NORTH, getContentPane());
		modyfikacjeLabel = new JLabel();
		modyfikacjeLabel.setText("Modyfikacje");
		modyfikacjeLabel.setText(SWF.msgs.getString("modification"));
		panel_1.add(modyfikacjeLabel);
		springLayout_2.putConstraint(SpringLayout.SOUTH, modyfikacjeLabel, 26, SpringLayout.NORTH, panel_1);
		springLayout_2.putConstraint(SpringLayout.NORTH, modyfikacjeLabel, 10, SpringLayout.NORTH, panel_1);
		dodajButton = new JButton();
		dodajButton.setEnabled(false);
		panel_1.add(dodajButton);
		springLayout_2.putConstraint(SpringLayout.EAST, modyfikacjeLabel, -5, SpringLayout.WEST, dodajButton);
		springLayout_2.putConstraint(SpringLayout.WEST, modyfikacjeLabel, 7, SpringLayout.WEST, panel_1);
		springLayout_2.putConstraint(SpringLayout.EAST, dodajButton, 185, SpringLayout.WEST, panel_1);
		springLayout_2.putConstraint(SpringLayout.WEST, dodajButton, 95, SpringLayout.WEST, panel_1);
		springLayout_2.putConstraint(SpringLayout.SOUTH, dodajButton, 31, SpringLayout.NORTH, panel_1);
		springLayout_2.putConstraint(SpringLayout.NORTH, dodajButton, 5, SpringLayout.NORTH, panel_1);
		dodajButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				if (nameRadioButton.isSelected()){
					trait.setName(comboBox_name.getSelectedIndex());
				}
				
				set();
			}
		});
		dodajButton.setActionCommand("");
		dodajButton.setText("Dodaj");
		dodajButton.setText(SWF.msgs.getString("add"));
		usunButton = new JButton();
		panel_1.add(usunButton);
		springLayout_2.putConstraint(SpringLayout.EAST, usunButton, 96, SpringLayout.EAST, dodajButton);
		springLayout_2.putConstraint(SpringLayout.WEST, usunButton, 5, SpringLayout.EAST, dodajButton);
		springLayout_2.putConstraint(SpringLayout.SOUTH, usunButton, 31, SpringLayout.NORTH, panel_1);
		springLayout_2.putConstraint(SpringLayout.NORTH, usunButton, 5, SpringLayout.NORTH, panel_1);
		usunButton.setEnabled(false);
		
		usunButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				
			}
		});
		usunButton.setText("Usu");
		usunButton.setText(SWF.msgs.getString("remove"));
		zamienButton = new JButton();
		zamienButton.setEnabled(false);
		panel_1.add(zamienButton);
		springLayout_2.putConstraint(SpringLayout.SOUTH, zamienButton, 31, SpringLayout.NORTH, panel_1);
		springLayout_2.putConstraint(SpringLayout.NORTH, zamienButton, 5, SpringLayout.NORTH, panel_1);
		springLayout_2.putConstraint(SpringLayout.EAST, zamienButton, 375, SpringLayout.WEST, panel_1);
		springLayout_2.putConstraint(SpringLayout.WEST, zamienButton, 284, SpringLayout.WEST, panel_1);
		zamienButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				if (nameRadioButton.isSelected()){
					trait.setName(comboBox_name.getSelectedIndex());
				}else if (type_nameRadioButton.isSelected()){
					trait.setName(comboBox_type_name.getSelectedIndex());
				}else if (vindexRadioButton.isSelected()){
					Trait_Slot_Const data = (Trait_Slot_Const)trait.getData();
					data.setSlot_id(comboBox_vindex.getSelectedIndex());
				}else if (classiRadioButton.isSelected()){
					Trait_class data = (Trait_class)trait.getData();
					data.setClassi(comboBox_classi.getSelectedIndex());
				}else if (functionRadioButton.isSelected()){
					Trait_function data = (Trait_function)trait.getData();
					data.setFunction(comboBox_function.getSelectedIndex());
				} else if (methodRadioButton.isSelected()){
					Trait_method_getter_setter data = (Trait_method_getter_setter)trait.getData();
					data.setMethod(comboBox_method.getSelectedIndex());
				}else if (metadataRadioButton.isSelected()){
					
				}
				
				set();
			}
		});
		zamienButton.setText("Zamie");
		zamienButton.setText(SWF.msgs.getString("replace"));
		springLayout.putConstraint(SpringLayout.NORTH, comboBox_name, 48, SpringLayout.NORTH, getContentPane());
		attr_finalCheckBox = new JCheckBox();
		attr_finalCheckBox.setText("ATTR_Final");
		getContentPane().add(attr_finalCheckBox);
		springLayout.putConstraint(SpringLayout.WEST, attr_finalCheckBox, 125, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.SOUTH, attr_finalCheckBox, 127, SpringLayout.NORTH, getContentPane());
		attr_overrideCheckBox = new JCheckBox();
		attr_overrideCheckBox.setText("ATTR_Override");
		getContentPane().add(attr_overrideCheckBox);
		springLayout.putConstraint(SpringLayout.SOUTH, attr_overrideCheckBox, 24, SpringLayout.SOUTH, attr_finalCheckBox);
		springLayout.putConstraint(SpringLayout.NORTH, attr_overrideCheckBox, 0, SpringLayout.SOUTH, attr_finalCheckBox);
		springLayout.putConstraint(SpringLayout.EAST, attr_overrideCheckBox, 118, SpringLayout.WEST, attr_finalCheckBox);
		springLayout.putConstraint(SpringLayout.WEST, attr_overrideCheckBox, 0, SpringLayout.WEST, attr_finalCheckBox);
		attr_metadataCheckBox = new JCheckBox();
		attr_metadataCheckBox.setText("ATTR_Metadata");
		getContentPane().add(attr_metadataCheckBox);
		springLayout.putConstraint(SpringLayout.SOUTH, attr_metadataCheckBox, 24, SpringLayout.SOUTH, attr_overrideCheckBox);
		springLayout.putConstraint(SpringLayout.NORTH, attr_metadataCheckBox, 0, SpringLayout.SOUTH, attr_overrideCheckBox);
		springLayout.putConstraint(SpringLayout.EAST, attr_metadataCheckBox, 118, SpringLayout.WEST, attr_overrideCheckBox);
		springLayout.putConstraint(SpringLayout.WEST, attr_metadataCheckBox, 0, SpringLayout.WEST, attr_overrideCheckBox);
		slot_idLabel = new JLabel();
		slot_idLabel.setText("slot_id");
		getContentPane().add(slot_idLabel);
		springLayout.putConstraint(SpringLayout.SOUTH, slot_idLabel, 204, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, slot_idLabel, 188, SpringLayout.NORTH, getContentPane());
		formattedTextField_slot_id = new JFormattedTextField();
		formattedTextField_slot_id.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				//int
				//trait.sInteger.parseInt(formattedTextField_slot_id.getText())
			}
		});
		getContentPane().add(formattedTextField_slot_id);
		springLayout.putConstraint(SpringLayout.EAST, formattedTextField_slot_id, 425, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.WEST, formattedTextField_slot_id, 125, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, formattedTextField_slot_id, 186, SpringLayout.NORTH, getContentPane());
		type_nameRadioButton = new JRadioButton();
		buttonGroup.add(type_nameRadioButton);
		type_nameRadioButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				dodajButton.setEnabled(false);
				usunButton.setEnabled(false);
				zamienButton.setEnabled(true);
			}
		});
		type_nameRadioButton.setText("type_name");
		getContentPane().add(type_nameRadioButton);
		springLayout.putConstraint(SpringLayout.EAST, slot_idLabel, 43, SpringLayout.WEST, type_nameRadioButton);
		springLayout.putConstraint(SpringLayout.WEST, slot_idLabel, 5, SpringLayout.WEST, type_nameRadioButton);
		springLayout.putConstraint(SpringLayout.EAST, type_nameRadioButton, 88, SpringLayout.WEST, nameRadioButton);
		springLayout.putConstraint(SpringLayout.WEST, type_nameRadioButton, 0, SpringLayout.WEST, nameRadioButton);
		springLayout.putConstraint(SpringLayout.SOUTH, type_nameRadioButton, 247, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, type_nameRadioButton, 223, SpringLayout.NORTH, getContentPane());
		formattedTextField_type_name = new JFormattedTextField();
		getContentPane().add(formattedTextField_type_name);
		springLayout.putConstraint(SpringLayout.EAST, formattedTextField_type_name, 425, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.WEST, formattedTextField_type_name, 125, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, formattedTextField_type_name, 225, SpringLayout.NORTH, getContentPane());
		comboBox_type_name = new JComboBox();
		getContentPane().add(comboBox_type_name);
		springLayout.putConstraint(SpringLayout.EAST, comboBox_type_name, 760, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.WEST, comboBox_type_name, 460, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.SOUTH, comboBox_type_name, 248, SpringLayout.NORTH, getContentPane());
		vindexRadioButton = new JRadioButton();
		buttonGroup.add(vindexRadioButton);
		vindexRadioButton.setText("vindex");
		getContentPane().add(vindexRadioButton);
		springLayout.putConstraint(SpringLayout.SOUTH, vindexRadioButton, 292, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, vindexRadioButton, 257, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.EAST, vindexRadioButton, 62, SpringLayout.WEST, type_nameRadioButton);
		springLayout.putConstraint(SpringLayout.WEST, vindexRadioButton, 0, SpringLayout.WEST, type_nameRadioButton);
		formattedTextField_vindex = new JFormattedTextField();
		getContentPane().add(formattedTextField_vindex);
		springLayout.putConstraint(SpringLayout.EAST, formattedTextField_vindex, 425, SpringLayout.WEST, getContentPane());
		springLayout.putConstraint(SpringLayout.WEST, formattedTextField_vindex, 125, SpringLayout.WEST, getContentPane());
		comboBox_vkind = new JComboBox();
		getContentPane().add(comboBox_vkind);
		springLayout.putConstraint(SpringLayout.SOUTH, comboBox_vkind, 323, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, comboBox_vkind, 298, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, formattedTextField_vindex, 264, SpringLayout.NORTH, getContentPane());
		classiRadioButton = new JRadioButton();
		buttonGroup.add(classiRadioButton);
		classiRadioButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				dodajButton.setEnabled(false);
				usunButton.setEnabled(false);
				zamienButton.setEnabled(true);
			}
		});
		classiRadioButton.setText("classi");
		getContentPane().add(classiRadioButton);
		springLayout.putConstraint(SpringLayout.SOUTH, classiRadioButton, 361, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, classiRadioButton, 340, SpringLayout.NORTH, getContentPane());
		formattedTextField_classi = new JFormattedTextField();
		getContentPane().add(formattedTextField_classi);
		springLayout.putConstraint(SpringLayout.SOUTH, formattedTextField_classi, 20, SpringLayout.NORTH, classiRadioButton);
		springLayout.putConstraint(SpringLayout.NORTH, formattedTextField_classi, 0, SpringLayout.NORTH, classiRadioButton);
		comboBox_classi = new JComboBox();
		getContentPane().add(comboBox_classi);
		springLayout.putConstraint(SpringLayout.EAST, comboBox_classi, 300, SpringLayout.WEST, comboBox_vkind);
		springLayout.putConstraint(SpringLayout.WEST, comboBox_classi, 0, SpringLayout.WEST, comboBox_vkind);
		springLayout.putConstraint(SpringLayout.SOUTH, comboBox_classi, 364, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, comboBox_classi, 337, SpringLayout.NORTH, getContentPane());
		methodRadioButton = new JRadioButton();
		buttonGroup.add(methodRadioButton);
		methodRadioButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				dodajButton.setEnabled(false);
				usunButton.setEnabled(false);
				zamienButton.setEnabled(true);
			}
		});
		methodRadioButton.setText("method");
		getContentPane().add(methodRadioButton);
		formattedTextField_method = new JFormattedTextField();
		getContentPane().add(formattedTextField_method);
		springLayout.putConstraint(SpringLayout.EAST, formattedTextField_method, 300, SpringLayout.WEST, textField_metadata_count);
		springLayout.putConstraint(SpringLayout.WEST, formattedTextField_method, 0, SpringLayout.WEST, textField_metadata_count);
		springLayout.putConstraint(SpringLayout.SOUTH, formattedTextField_method, 473, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, formattedTextField_method, 453, SpringLayout.NORTH, getContentPane());
		comboBox_method = new JComboBox();
		getContentPane().add(comboBox_method);
		springLayout.putConstraint(SpringLayout.NORTH, comboBox_method, 451, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.SOUTH, methodRadioButton, 475, SpringLayout.NORTH, getContentPane());
		functionRadioButton = new JRadioButton();
		buttonGroup.add(functionRadioButton);
		functionRadioButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				dodajButton.setEnabled(false);
				usunButton.setEnabled(false);
				zamienButton.setEnabled(true);
			}
		});
		functionRadioButton.setText("function");
		getContentPane().add(functionRadioButton);
		springLayout.putConstraint(SpringLayout.EAST, methodRadioButton, 68, SpringLayout.WEST, functionRadioButton);
		springLayout.putConstraint(SpringLayout.WEST, methodRadioButton, 0, SpringLayout.WEST, functionRadioButton);
		springLayout.putConstraint(SpringLayout.EAST, functionRadioButton, 71, SpringLayout.WEST, classiRadioButton);
		springLayout.putConstraint(SpringLayout.WEST, functionRadioButton, 0, SpringLayout.WEST, classiRadioButton);
		springLayout.putConstraint(SpringLayout.SOUTH, functionRadioButton, 401, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, functionRadioButton, 379, SpringLayout.NORTH, getContentPane());
		formattedTextField_function = new JFormattedTextField();
		getContentPane().add(formattedTextField_function);
		springLayout.putConstraint(SpringLayout.EAST, textField_metadata_count, 300, SpringLayout.WEST, formattedTextField_function);
		springLayout.putConstraint(SpringLayout.WEST, textField_metadata_count, 0, SpringLayout.WEST, formattedTextField_function);
		springLayout.putConstraint(SpringLayout.SOUTH, formattedTextField_function, 400, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.EAST, formattedTextField_function, 300, SpringLayout.WEST, formattedTextField_classi);
		springLayout.putConstraint(SpringLayout.WEST, formattedTextField_function, 0, SpringLayout.WEST, formattedTextField_classi);
		comboBox_function = new JComboBox();
		getContentPane().add(comboBox_function);
		springLayout.putConstraint(SpringLayout.EAST, comboBox_method, 300, SpringLayout.WEST, comboBox_function);
		springLayout.putConstraint(SpringLayout.WEST, comboBox_method, 0, SpringLayout.WEST, comboBox_function);
		springLayout.putConstraint(SpringLayout.SOUTH, comboBox_function, 403, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.EAST, comboBox_function, 300, SpringLayout.WEST, comboBox_classi);
		springLayout.putConstraint(SpringLayout.WEST, comboBox_function, 0, SpringLayout.WEST, comboBox_classi);
		vkindRadioButton = new JRadioButton();
		vkindRadioButton.setEnabled(false);
		buttonGroup.add(vkindRadioButton);
		vkindRadioButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				dodajButton.setEnabled(false);
				usunButton.setEnabled(false);
				zamienButton.setEnabled(false);
			}
		});
		vkindRadioButton.setText("vkind");
		getContentPane().add(vkindRadioButton);
		springLayout.putConstraint(SpringLayout.EAST, classiRadioButton, 81, SpringLayout.WEST, vkindRadioButton);
		springLayout.putConstraint(SpringLayout.WEST, classiRadioButton, 0, SpringLayout.WEST, vkindRadioButton);
		springLayout.putConstraint(SpringLayout.SOUTH, vkindRadioButton, 324, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, vkindRadioButton, 297, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.EAST, vkindRadioButton, 55, SpringLayout.WEST, vindexRadioButton);
		springLayout.putConstraint(SpringLayout.WEST, vkindRadioButton, 0, SpringLayout.WEST, vindexRadioButton);
		metadata_countLabel = new JLabel();
		metadata_countLabel.setText("metadata_count");
		getContentPane().add(metadata_countLabel);
		springLayout.putConstraint(SpringLayout.EAST, metadataRadioButton, 110, SpringLayout.WEST, metadata_countLabel);
		springLayout.putConstraint(SpringLayout.WEST, metadataRadioButton, 0, SpringLayout.WEST, metadata_countLabel);
		springLayout.putConstraint(SpringLayout.EAST, metadata_countLabel, 93, SpringLayout.WEST, methodRadioButton);
		springLayout.putConstraint(SpringLayout.WEST, metadata_countLabel, 0, SpringLayout.WEST, methodRadioButton);
		springLayout.putConstraint(SpringLayout.NORTH, metadata_countLabel, 495, SpringLayout.NORTH, getContentPane());
		comboBox_vindex = new JComboBox();
		getContentPane().add(comboBox_vindex);
		springLayout.putConstraint(SpringLayout.EAST, comboBox_vindex, 300, SpringLayout.WEST, comboBox_type_name);
		springLayout.putConstraint(SpringLayout.WEST, comboBox_vindex, 0, SpringLayout.WEST, comboBox_type_name);
		springLayout.putConstraint(SpringLayout.EAST, comboBox_vkind, 300, SpringLayout.WEST, comboBox_vindex);
		springLayout.putConstraint(SpringLayout.WEST, comboBox_vkind, 0, SpringLayout.WEST, comboBox_vindex);
		springLayout.putConstraint(SpringLayout.SOUTH, comboBox_vindex, 287, SpringLayout.NORTH, getContentPane());
		formattedTextField_vkind = new JFormattedTextField();
		getContentPane().add(formattedTextField_vkind);
		springLayout.putConstraint(SpringLayout.EAST, formattedTextField_classi, 300, SpringLayout.WEST, formattedTextField_vkind);
		springLayout.putConstraint(SpringLayout.WEST, formattedTextField_classi, 0, SpringLayout.WEST, formattedTextField_vkind);
		springLayout.putConstraint(SpringLayout.SOUTH, formattedTextField_vkind, 320, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.NORTH, formattedTextField_vkind, 300, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.EAST, formattedTextField_vkind, 300, SpringLayout.WEST, formattedTextField_vindex);
		springLayout.putConstraint(SpringLayout.WEST, formattedTextField_vkind, 0, SpringLayout.WEST, formattedTextField_vindex);
		disp_idLabel = new JLabel();
		disp_idLabel.setText("disp_id");
		getContentPane().add(disp_idLabel);
		springLayout.putConstraint(SpringLayout.NORTH, disp_idLabel, 422, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.WEST, disp_idLabel, 5, SpringLayout.WEST, functionRadioButton);
		formattedTextField_disp_id = new JFormattedTextField();
		formattedTextField_disp_id.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				//Integer.parseInt(formattedTextField_disp_id.getText());
			}
		});
		getContentPane().add(formattedTextField_disp_id);
		springLayout.putConstraint(SpringLayout.SOUTH, formattedTextField_disp_id, 440, SpringLayout.NORTH, getContentPane());
		springLayout.putConstraint(SpringLayout.EAST, formattedTextField_disp_id, 300, SpringLayout.WEST, formattedTextField_function);
		springLayout.putConstraint(SpringLayout.WEST, formattedTextField_disp_id, 0, SpringLayout.WEST, formattedTextField_function);
		
		comboBox_metadata_2 = new JComboBox();
		getContentPane().add(comboBox_metadata_2);
		springLayout.putConstraint(SpringLayout.EAST, comboBox_metadata_2, 0, SpringLayout.EAST, comboBox_method);
		springLayout.putConstraint(SpringLayout.WEST, comboBox_metadata_2, 0, SpringLayout.WEST, comboBox_method);
		springLayout.putConstraint(SpringLayout.NORTH, comboBox_metadata_2, 533, SpringLayout.NORTH, getContentPane());
		comboBox_kind = new JComboBox();
		getContentPane().add(comboBox_kind);
		springLayout.putConstraint(SpringLayout.EAST, comboBox_kind, 0, SpringLayout.EAST, comboBox_name);
		springLayout.putConstraint(SpringLayout.WEST, comboBox_kind, 0, SpringLayout.WEST, comboBox_name);
		springLayout.putConstraint(SpringLayout.SOUTH, comboBox_kind, 30, SpringLayout.SOUTH, comboBox_name);
		springLayout.putConstraint(SpringLayout.NORTH, comboBox_kind, 5, SpringLayout.SOUTH, comboBox_name);
		kindRadioButton = new JRadioButton();
		buttonGroup.add(kindRadioButton);
		kindRadioButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				dodajButton.setEnabled(false);
				usunButton.setEnabled(false);
				zamienButton.setEnabled(false);
			}
		});
		kindRadioButton.setText("kind");
		getContentPane().add(kindRadioButton);
		springLayout.putConstraint(SpringLayout.SOUTH, kindRadioButton, 24, SpringLayout.SOUTH, nameRadioButton);
		springLayout.putConstraint(SpringLayout.NORTH, kindRadioButton, 0, SpringLayout.SOUTH, nameRadioButton);
		springLayout.putConstraint(SpringLayout.EAST, kindRadioButton, 49, SpringLayout.WEST, nameRadioButton);
		springLayout.putConstraint(SpringLayout.WEST, kindRadioButton, 0, SpringLayout.WEST, nameRadioButton);
		init();
	}

	
	public void init(){
		AbcFile abc = ((DoABC)Main.choosedTag).getAbcData();
		
		ArrayList<MultinameInfo> multinames =  cpool.getMultinames();
		
		for (int i =0; i<multinames.size();i++){
			comboBox_name.addItem(multinames.get(i));
			comboBox_type_name.addItem(multinames.get(i));
		}
		
		if (comboBox_name.getItemCount()>0){
			comboBox_name.setSelectedIndex(0);
		}
		
		for (int i =0; i < ENtraits_info.size();i++)
			comboBox.addItem(ENtraits_info.get(i));
		
		Iterator<String> iter = trait.getFlagsKind().values().iterator();
		
		while (iter.hasNext()){
			comboBox_vkind.addItem(iter.next());
		}
		
		for (ClassInfo cla :abc.ENclass_info)
			comboBox_classi.addItem(cla);
		
		for(MethodInfo method : abc.ENmethod_info){
			comboBox_function.addItem(method);
			comboBox_method.addItem(method);
		}
			
	}
	public void set(){

		Iterator<String> iter = trait.getFlagsKind().values().iterator();
		
		comboBox_kind.removeAllItems();
		while (iter.hasNext()){
			comboBox_kind.addItem(iter.next());
		}
		
		
		textField_name.setText(""+trait.getName_string());
		
		textField_kind.setText(trait.getKind_string());
		
		int kindLow = trait.getKind()&0xF;
		
		int kindHigh = trait.getKind() & 0xf0;
		//textField_kind
		
		attr_finalCheckBox.setSelected(false);
		attr_overrideCheckBox.setSelected(false);
		attr_metadataCheckBox.setSelected(false);
		
		if(kindHigh ==0x10) {
			attr_finalCheckBox.setSelected(true);
		}
		if(kindHigh ==0x20){
			attr_overrideCheckBox.setSelected(true);
		}
		if(kindHigh ==0x40){
			attr_metadataCheckBox.setSelected(true);
		}
		
		
		if (kindLow == 0x00 || kindLow == 0x06){
			
			Trait_Slot_Const tsc = (Trait_Slot_Const)trait.getData(); 
			formattedTextField_slot_id.setText(""+tsc.getSlot_id());
			formattedTextField_type_name.setValue(cpool.getMultinames().get(tsc.getType_name()));
			int kind2 = tsc.getVkind();
			
			
			formattedTextField_vkind.setText(tsc.getVkind_string());
			
			formattedTextField_vindex.setEnabled(true);
			vindexRadioButton.setEnabled(true);
			if (tsc.getVindex()>0){
				formattedTextField_vkind.setEnabled(true);
				vkindRadioButton.setEnabled(true);
			}
			formattedTextField_slot_id.setEnabled(true);
			formattedTextField_type_name.setEnabled(true);
			type_nameRadioButton.setEnabled(true);
			
			formattedTextField_classi.setEnabled(false);
			classiRadioButton.setEnabled(false);
			formattedTextField_function.setEnabled(false);
			functionRadioButton.setEnabled(false);
			formattedTextField_method.setEnabled(false);
			methodRadioButton.setEnabled(false);
			formattedTextField_disp_id.setEnabled(false);

			formattedTextField_vindex.setText(""+tsc.getVindex());
			
			if (kind2 == 0x03){
				formattedTextField_vindex.setText(""+cpool.getInts().get(tsc.getVindex()));
				comboBox_vindex.removeAllItems();
				for (Integer i: cpool.getInts())
					comboBox_vindex.addItem(i);
			}else if (kind2 == 0x04){
				comboBox_vindex.removeAllItems();
				for(Integer i: cpool.getUints())
					comboBox_vindex.addItem(i);
				formattedTextField_vindex.setText(""+cpool.getUints().get(tsc.getVindex()));
			}else if (kind2 == 0x06){
				for(Double i: cpool.getDoubles())
					comboBox_vindex.addItem(i);
				formattedTextField_vindex.setText(""+cpool.getDoubles().get(tsc.getVindex()));
			}else if (kind2 == 0x01){
				for(StringInfo i: cpool.getStrings())
					comboBox_vindex.addItem(i);
				formattedTextField_vindex.setValue(cpool.getStrings().get(tsc.getVindex()));
			}else if (kind2 == 0x0B){
				comboBox_vindex.removeAllItems();
				formattedTextField_vindex.setText(""+tsc.getVindex());
			}else if (kind2 == 0x0A){
				comboBox_vindex.removeAllItems();
				formattedTextField_vindex.setText(""+tsc.getVindex());
			}else if (kind2 == 0x0C){
				comboBox_vindex.removeAllItems();
				formattedTextField_vindex.setText(""+tsc.getVindex());
			}else if (kind2 == 0x00){
				comboBox_vindex.removeAllItems();
				formattedTextField_vindex.setText(""+tsc.getVindex());
			}else if (kind2 == 0x08){
				for(NamespaceInfo i: cpool.getNamespaces())
					comboBox_vindex.addItem(i);
				formattedTextField_vindex.setValue(cpool.getNamespaces().get(tsc.getVindex()));
				
			}else if (kind2 == 0x16){
				for(NamespaceInfo i: cpool.getNamespaces())
					comboBox_vindex.addItem(i);
				formattedTextField_vindex.setValue(cpool.getNamespaces().get(tsc.getVindex()));
			}else if (kind2 == 0x17){
				for(NamespaceInfo i: cpool.getNamespaces())
					comboBox_vindex.addItem(i);
				formattedTextField_vindex.setValue(cpool.getNamespaces().get(tsc.getVindex()));
			}else if (kind2 == 0x18){
				for(NamespaceInfo i: cpool.getNamespaces())
					comboBox_vindex.addItem(i);
				formattedTextField_vindex.setValue(cpool.getNamespaces().get(tsc.getVindex()));
			}else if (kind2 == 0x19){
				for(NamespaceInfo i: cpool.getNamespaces())
					comboBox_vindex.addItem(i);
				formattedTextField_vindex.setValue(cpool.getNamespaces().get(tsc.getVindex()));
			}else if (kind2 == 0x1A){
				for(NamespaceInfo i: cpool.getNamespaces())
					comboBox_vindex.addItem(i);
				formattedTextField_vindex.setValue(cpool.getNamespaces().get(tsc.getVindex()));
			}else if (kind2 == 0x05){
				for(NamespaceInfo i: cpool.getNamespaces())
					comboBox_vindex.addItem(i);
				formattedTextField_vindex.setValue(cpool.getNamespaces().get(tsc.getVindex()));
			}
			
			
		}else if (kindLow == 0x01 || kindLow == 0x02 || kindLow == 0x03){
			AbcFile abc =((DoABC)Main.choosedTag).getAbcData();
			Trait_method_getter_setter tmgs = (Trait_method_getter_setter)trait.getData(); 
			formattedTextField_disp_id.setText(""+tmgs.getDisp_id());
			formattedTextField_method.setValue(abc.ENmethod_info.get(tmgs.getMethod()));
			
			formattedTextField_disp_id.setEnabled(true);
			formattedTextField_method.setEnabled(true);
			methodRadioButton.setEnabled(true);
			
			formattedTextField_slot_id.setEnabled(false);
			formattedTextField_type_name.setEnabled(false);
			type_nameRadioButton.setEnabled(false);
			formattedTextField_vindex.setEnabled(false);
			vindexRadioButton.setEnabled(false);
			formattedTextField_vkind.setEnabled(false);
			vkindRadioButton.setEnabled(false);
			formattedTextField_classi.setEnabled(false);
			formattedTextField_classi.setEnabled(false);
			formattedTextField_function.setEnabled(false);
			functionRadioButton.setEnabled(false);
			
		}else if (kindLow == 0x04){
			AbcFile abc = ((DoABC)Main.choosedTag).getAbcData();
			
			Trait_class tc = (Trait_class)trait.getData(); 
			
			formattedTextField_slot_id.setText(""+tc.getSlot_id());
			formattedTextField_classi.setValue(abc.ENclass_info.get(tc.getClassi()));
			
			formattedTextField_slot_id.setEnabled(true);
			formattedTextField_classi.setEnabled(true);
			classiRadioButton.setEnabled(true);
			
			formattedTextField_type_name.setEnabled(false);
			type_nameRadioButton.setEnabled(false);
			formattedTextField_vindex.setEnabled(false);
			vindexRadioButton.setEnabled(false);
			formattedTextField_vkind.setEnabled(false);
			vkindRadioButton.setEnabled(false);
			formattedTextField_function.setEnabled(false);
			functionRadioButton.setEnabled(false);
			formattedTextField_disp_id.setEnabled(false);
			formattedTextField_method.setEnabled(false);
			methodRadioButton.setEnabled(false);
			
		}else if (kindLow == 0x05){
			Trait_function tf = (Trait_function)trait.getData(); 
			AbcFile abc = ((DoABC)Main.choosedTag).getAbcData();
			formattedTextField_slot_id.setText(""+tf.getSlot_id());
			formattedTextField_function.setValue(abc.ENmethod_info.get(tf.getFunction()));
			
			formattedTextField_slot_id.setEnabled(true);
			formattedTextField_function.setEnabled(true);
			functionRadioButton.setEnabled(true);
			
			formattedTextField_type_name.setEnabled(false);
			type_nameRadioButton.setEnabled(false);
			formattedTextField_vindex.setEnabled(false);
			vindexRadioButton.setEnabled(false);
			formattedTextField_vkind.setEnabled(false);
			vkindRadioButton.setEnabled(false);
			formattedTextField_classi.setEnabled(false);
			classiRadioButton.setEnabled(false);
			formattedTextField_disp_id.setEnabled(false);
			formattedTextField_method.setEnabled(false);
			methodRadioButton.setEnabled(false);
			
		}
		
		//textField_data.setText(""+trait.getData());
		textField_metadata_count.setText(""+trait.getMetadata_count());
		
		
		comboBox_metadata.removeAllItems();
		for (int i =0; i < trait.getMetadata().size();i++){
			comboBox_metadata.addItem(trait.getMetadata().get(i));
		}
		
	}
	
	
	
}
